from flask import Flask, request
from flask_cors import CORS
from pythonosc import udp_client

app = Flask(__name__)
CORS(app)

osc_client = udp_client.SimpleUDPClient("127.0.0.1", 7000)

@app.route("/signal", methods=["POST"])
def signal():
    data = request.get_json()
    print("got", data)

    if data.get("status") == "right":
        osc_client.send_message("/daslight/right", 255)
    elif data.get("status") == "wrong":
        osc_client.send_message("/daslight/wrong", 255)
    elif data.get("status") == "round":
        osc_client.send_message("/daslight/round", 255)
    elif data.get("status") == "test":
        osc_client.send_message("/daslight/test", 255)
    else:
        osc_client.send_message("/daslight/unknown", 0)

    return {"status": "ok"}, 200

if __name__ == "__main__":
    app.run(host="127.0.0.1", port=5000)
