from flask import Flask, request
from flask_cors import CORS
from pythonosc import udp_client

app = Flask(__name__)
CORS(app)

# OSC-Client konfigurieren (IP + Port des OSC-Empfängers anpassen)
osc_client = udp_client.SimpleUDPClient("127.0.0.1", 7000)

@app.route("/signal", methods=["POST"])
def signal():
    data = request.get_json()
    print("got", data)
    # Sende OSC-Nachricht bei Eingang
    osc_client.send_message("/from_flask", 255)
    return {"status": "ok"}, 200

if __name__ == "__main__":
    app.run(host="127.0.0.1", port=5000)
